//
//  OPItemField.h
//  1Passwd
//
//  Created by Roustem Karimov on 09-11-03.
//  Copyright 2007 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface OPItemField : NSObject

@property (nonatomic, readonly) NSString * identifier;
@property (nonatomic, readonly) NSString * type;
@property (nonatomic, copy) NSString * title;
@property (nonatomic, copy) NSDictionary * attributes;

@property (nonatomic, readonly) NSString * stringValue;
@property (nonatomic, readonly) NSString * displayStringValue;
@property (nonatomic, readonly) NSString * clipboardStringValue;
@property (nonatomic) id jsonValue;
@property (nonatomic) id rawValue;

@property (nonatomic, readonly, getter = isGuarded) BOOL guarded;
@property (nonatomic, readonly, getter = isMultiline) BOOL multiline;
@property (nonatomic, readonly, getter = isPasswordGeneratorDisabled) BOOL passwordGeneratorDisabled;

+ (NSString *)typeName;
+ (NSString *)localizedTypeName;
+ (NSString *)uniqueFieldIdentifier;
+ (instancetype)fieldWithType:(NSString *)typeName;
+ (instancetype)fieldWithType:(NSString *)typeName identifier:(NSString *)identifier;
+ (instancetype)fieldWithIdentifier:(NSString *)identifier;

- (instancetype)initWithIdentifier:(NSString *)identifier;

- (OPItemField *)conflictCopyWithUniqueFieldIdentifierForConflict:(NSString *)identifier;
- (void)repairMissingIdentifier:(NSString *)identifer; // For use with the OPItemCleanupMigration

- (BOOL)isEmpty;
- (BOOL)isEqual:(id)other;
- (BOOL)isValueEqualTo:(id)testValue;


- (BOOL)isURLField;
- (BOOL)isConcealedField;
- (BOOL)isTOTPField;
- (BOOL)isEmailField;
- (BOOL)isPhoneField;
- (BOOL)isStringField;
- (BOOL)isAddressField;
- (BOOL)isMenuField;
- (BOOL)isMonthYearField;
- (BOOL)isDateField;
- (BOOL)isCreditCardTypeField;
- (BOOL)isCreditCardNumberField;
- (BOOL)isReferenceField;
- (BOOL)isUnknownField;

@end
